PACKAGE p_qual IS    
  TYPE int_vector IS ARRAY(NATURAL RANGE <>) OF INTEGER;
    
  FUNCTION average( a : int_vector) RETURN INTEGER;
    
  FUNCTION average( a : int_vector) RETURN REAL;
 
END p_qual; 

USE WORK.p_qual.ALL; 
ENTITY normalize IS    
  PORT( factor : IN REAL;           
        points : IN int_vector;          
        result : OUT REAL); 
END normalize; 

ARCHITECTURE qual_exp OF normalize IS 
BEGIN    
  result <= REAL'(average(points)) * factor; 
END qual_exp;


